source("D2prior_funcs.R")
source("D2ess_prior.R")
source("D2run_analysis.R")
source("D2post_funcs.R")

source("D1prior_funcs.R")
source("D1post_funcs.R")
source("D1ess_prior.R")
source("D1prob_calc.R")
source("D1run_analysis.R")
source("D1design.R")


shinyServer(function(input, output){
	
	## Need to determine parameters of the prior distribution
	## Reactive expression to generate the requested distribution. This is called
	## whenever the inputs change. The renderers defined below then all use the value 
	## computed from this expression
	priorParam <- reactive({
        if(!input$nomycyc){
            priorcall(input$lambdaC_q1, input$lambdaC_q2, input$lambdaE_q1, input$lambdaE_q2, input$expert)	
        }else{
        	z = scan("D1Answers.txt", nmax = 4)
            prior_nomycyc(z[1], z[2], z[3], z[4], input$expert)
        }
	})
	
	postParam <- reactive({
		if((input$posterior40 | input$posterior20) & !input$nomycyc){
			if(input$posterior40){
				postcall(40 - input$n_cyc40, input$mmf_succ40, input$n_cyc40, input$cyc_succ40, priorParam(), input$posterior40)
			}else{
				postcall(20 - input$n_cyc20, input$mmf_succ20, input$n_cyc20, input$cyc_succ20, priorParam(), input$posterior40)
			}
		}else if((input$posterior40 | input$posterior20) & input$nomycyc){
			if(input$posterior40){
            	post_nomycyc(40 - input$n_cyc40, input$mmf_succ40, input$n_cyc40, input$cyc_succ40, priorParam(), input$posterior40)
            }else{
            	post_nomycyc(20 - input$n_cyc20, input$mmf_succ20, input$n_cyc20, input$cyc_succ20, priorParam(), input$posterior40)
            }
        }else{
			NULL
		}
	})
	
	
	## generating data to plot the prior and posterior densities of pC, pE and theta. 
	pC_priorDens <- reactive({
		z = priorParam()
        if(!input$nomycyc){
            x = vector(mode="numeric", length =19)
            y = distPlot(0,0,0,0, x, z, as.character("pC"), as.logical("T"))
        }else{
            x = vector(mode="numeric", length = 20)
            y = Plot_nomycyc(0,0,0,0, x, z, as.character("pC"), as.logical("T"))
        }
            return(y)
	})
	
	pC_postDens <- reactive({
		z = priorParam()
		x = postParam()
        if(!input$nomycyc){
        	if(input$posterior40){
            	y = distPlot(40 - input$n_cyc40, input$mmf_succ40, input$n_cyc40, input$cyc_succ40, x, z, as.character("pC"), as.logical("F"))
            }else{
            	y = distPlot(20 - input$n_cyc20, input$mmf_succ20, input$n_cyc20, input$cyc_succ20, x, z, as.character("pC"), as.logical("F"))
            }
        }else{
        	if(input$posterior40){
            	y = Plot_nomycyc(40 - input$n_cyc40, input$mmf_succ40, input$n_cyc40, input$cyc_succ40, x, z, as.character("pC"), as.logical("F"))
            }else{
            	y = Plot_nomycyc(20 - input$n_cyc20, input$mmf_succ20, input$n_cyc20, input$cyc_succ20, x, z, as.character("pC"), as.logical("F"))
            }
        }
		return(y)
	})
	
	pE_priorDens <- reactive({
		z = priorParam()
        if(!input$nomycyc){
            x = vector(mode="numeric", length =19)
            y = distPlot(0,0,0,0, x, z, as.character("pE"), as.logical("T"))
        }else{
            x = vector(mode="numeric", length = 20)
            y = Plot_nomycyc(0,0,0,0, x, z, as.character("pE"), as.logical("T"))
        }
		return(y)
	})
	pE_postDens <- reactive({
		z = priorParam()
		x = postParam()
        if(!input$nomycyc){
        	if(input$posterior40){
            	y = distPlot(40 - input$n_cyc40, input$mmf_succ40, input$n_cyc40, input$cyc_succ40, x, z, as.character("pE"), as.logical("F"))
            }else{
            	y = distPlot(20 - input$n_cyc20, input$mmf_succ20, input$n_cyc20, input$cyc_succ20, x, z, as.character("pE"), as.logical("F"))
            }
        }else{
        	if(input$posterior40){
            	y = Plot_nomycyc(40 - input$n_cyc40, input$mmf_succ40, input$n_cyc40, input$cyc_succ40, x, z, as.character("pE"), as.logical("F"))
            }else{
            	y = Plot_nomycyc(20 - input$n_cyc20, input$mmf_succ20, input$n_cyc20, input$cyc_succ20, x, z, as.character("pE"), as.logical("F"))
            }
        }
		return(y)
	})
	
	theta_priorDens <- reactive({
		## Return the data to plot the prior and posterior densities of theta.
		z = priorParam()
        if(!input$nomycyc){
            x = vector(mode="numeric", length =19)
            y = distPlot(0,0,0,0,x, z, as.character("theta"), as.logical("T"))
        }else{
            x = vector(mode="numeric", length =20)
            y = Plot_nomycyc(0,0,0,0,x, z, as.character("theta"), as.logical("T"))
        }
		return(y)
	})
	
	theta_postDens <- reactive({
		## Return the data to plot the prior and posterior densities of theta.
		z = priorParam()
		x = postParam() 
        if(!input$nomycyc){
        	if(input$posterior40){
            	y = distPlot(40 - input$n_cyc40, input$mmf_succ40, input$n_cyc40, input$cyc_succ40, x, z, as.character("theta"),as.logical("F"))
            }else{
            	y = distPlot(20 - input$n_cyc20, input$mmf_succ20, input$n_cyc20, input$cyc_succ20, x, z, as.character("theta"), as.logical("F"))
            }
        }else{
        	if(input$posterior40){
            	y = Plot_nomycyc(40 - input$n_cyc40, input$mmf_succ40, input$n_cyc40, input$cyc_succ40, x, z, as.character("theta"), as.logical("F"))
            }else{
            	y = Plot_nomycyc(20 - input$n_cyc20, input$mmf_succ20, input$n_cyc20, input$cyc_succ20, x, z, as.character("theta"), as.logical("F"))
            }
        }
		return(y)
	})
	
	lambdaC_priorDens <- reactive({
        if(!input$nomycyc){
            z = priorParam()
            x = vector(mode="numeric", length =19)
            y = distPlot(0,0,0,0 ,x, z, as.character("lambdaC"), as.logical("T"))
            return(y)
        }else{
            NULL
        }
	})
	
	lambdaE_priorDens <- reactive({
        if(!input$nomycyc){
            z = priorParam()
            x = vector(mode="numeric", length =19)
            y = distPlot(0,0,0,0 ,x, z, as.character("lambdaE"), as.logical("T"))
            return(y)
        }else{
            NULL
        }
	})
	
		
	## Outputting prior and posterior densities of pC, pE and theta.
	output$pc_density <- renderPlot({		
		if(input$posterior40 | input$posterior20){
			y = pC_priorDens()
			x = pC_postDens()
			if(!input$nomycyc){
				if(input$posterior40){
					leg1 = c(bquote("Posterior:" ~ n[C] ==  .(input$n_cyc40) ~ S[C]  == .(input$cyc_succ40) ~ n[M] == .(40 - input$n_cyc40) ~ S[M] ==  .(input$mmf_succ40)), "Prior (inc. MYCYC data)")
				}else{
					leg1 = c(bquote("Posterior:" ~ n[C] ==  .(input$n_cyc20) ~ S[C]  == .(input$cyc_succ20) ~ n[M] == .(20 - input$n_cyc20) ~ S[M] ==  .(input$mmf_succ20)), "Prior (inc. MYCYC data)")
				}
			}else{
				if(input$posterior40){
					leg1 = c(bquote("Posterior:" ~ n[C] ==  .(input$n_cyc40) ~ S[C]  == .(input$cyc_succ40) ~ n[M] == .(40 - input$n_cyc40) ~ S[M] ==  .(input$mmf_succ40)), "Prior (no MYCYC data)")
				}else{
					leg1 = c(bquote("Posterior:" ~ n[C] ==  .(input$n_cyc20) ~ S[C]  == .(input$cyc_succ20) ~ n[M] == .(20 - input$n_cyc20) ~ S[M] ==  .(input$mmf_succ20)), "Prior (no MYCYC data)")
				}
			}
			
			postPlot = plot(x$gridc, x$postd, type="l", lty=2, lwd=3, col="dark red", main = "Prior and posterior densities of 6-month remission rate on CYC", xlab = "CYC 6-month remission rate", ylab="Density", ylim = range(c(x$postd, y$dens)), xlim =c(0,1), cex.lab = 1.5, cex.axis=1.5, cex.main = 1.8) 
			lines(y$gridc, y$dens, lty=1, lwd=3, col="red")
			legend("topleft", as.expression(leg1), col = c("dark red","red"), lty = c(2,1), lwd = c(3,3), cex=1.2, bty="n")	
		}else{
			## only plot the prior distribution
			x = pC_priorDens()
			  
            if(!input$nomycyc){
            	z1 = scan("Day1Prior.txt", nmax = 6)
            	z = vector(mode="numeric", length=10)
            	z[1] = z1[1]
            	z[2] = z1[2]
            	z[9] = z1[3]
            	z[10] = z1[4]
            	h = vector(mode="numeric", length = 20)
            	y = Plot_nomycyc(0, 0, 0, 0, h, z, as.character("pC"), as.logical("T"))
	
                ## plot prior distributions incorporating and disregarding the mycyc data
            	priorPlot = plot(x$gridc, x$dens, type="l", lty=1, lwd=3, col="red", main = "Prior density of 6-month remission rate on CYC", xlab = "CYC 6-month remission rate", ylab="Density", ylim = range(c(x$dens, y$dens)), xlim =c(0,1), cex.lab = 1.5, cex.axis=1.5, cex.main = 1.8)
                lines(y$gridc, y$dens, lty=1, lwd =3, col = "black")
                legend("topleft", c("Inc. MYCYC data", "No MYCYC data"), col = c("red","black"), lty = c(1,1), lwd = c(3,3), cex=1.2, bty="n")
            }else{
            	## plot the prior distribution based on expert opinion alone
            	priorPlot = plot(x$gridc, x$dens, type="l", lty=1, lwd=3, col="black", main = "Prior density of 6-month remission rate on CYC (no MYCYC data)", xlab = "CYC 6-month remission rate", ylab="Density", xlim =c(0,1), cex.lab = 1.5, cex.axis=1.5, cex.main = 1.8)
            }
		}
	})
	
	output$pe_density <- renderPlot({		
		if(input$posterior40 | input$posterior20){
			y = pE_priorDens()
			x = pE_postDens()
			
			if(!input$nomycyc){
				if(input$posterior40){
					leg1 = c(bquote("Posterior:" ~ n[C] ==  .(input$n_cyc40) ~ S[C]  == .(input$cyc_succ40) ~ n[M] == .(40 - input$n_cyc40) ~ S[M] ==  .(input$mmf_succ40)), "Prior (inc. MYCYC data)")
				}else{
					leg1 = c(bquote("Posterior:" ~ n[C] ==  .(input$n_cyc20) ~ S[C]  == .(input$cyc_succ20) ~ n[M] == .(20 - input$n_cyc20) ~ S[M] ==  .(input$mmf_succ20)), "Prior (inc. MYCYC data)")
				}
			}else{
				if(input$posterior40){
					leg1 = c(bquote("Posterior:" ~ n[C] ==  .(input$n_cyc40) ~ S[C]  == .(input$cyc_succ40) ~ n[M] == .(40 - input$n_cyc40) ~ S[M] ==  .(input$mmf_succ40)), "Prior (no MYCYC data)")
				}else{
					leg1 = c(bquote("Posterior:" ~ n[C] ==  .(input$n_cyc20) ~ S[C]  == .(input$cyc_succ20) ~ n[M] == .(20 - input$n_cyc20) ~ S[M] ==  .(input$mmf_succ20)), "Prior (no MYCYC data)")
				}
			}
			
			postPlot = plot(x$gride, x$postd, type="l", lty=2, lwd=3, col="dark green", main="Prior and posterior densities of 6-month remission rate on MMF", xlab = "MMF 6-month remission rate", ylab="Density", ylim = range(c(x$postd, y$dens)), xlim =c(0,1), cex.lab = 1.5, cex.axis=1.5, cex.main = 1.8) 
			lines(y$gride, y$dens, lty=1, lwd=3, col="green")
			legend("topleft", as.expression(leg1), col = c("dark green","green"), lty = c(2,1), lwd = c(3,3), cex=1.2, bty="n")	
		}else{
			
			x = pE_priorDens()
			
            if(!input$nomycyc){
            	z1 = scan("Day1Prior.txt", nmax=6)
            	z = vector(mode="numeric", length=10)
            	z[1] = z1[1]
            	z[2] = z1[2]
            	z[9] = z1[3]
            	z[10] = z1[4]
            	h = vector(mode="numeric", length = 20)
            	y = Plot_nomycyc(40 - input$n_cyc40, input$mmf_succ40, input$n_cyc40, input$cyc_succ40, h, z, as.character("pE"), as.logical("T"))
            
                ## plot prior densities incorporating and disregarding the mycyc data
                priorPlot = plot(x$gride, x$dens, type="l", lty=1, lwd=3, col="green", main = "Prior density of 6-month remission rate on MMF", xlab = "MMF 6-month remission rate", ylab="Density", ylim = range(c(x$dens, y$dens)), xlim =c(0,1), cex.lab = 1.5, cex.axis=1.5, cex.main = 1.8)
                lines(y$gride, y$dens, lty=1, lwd =3, col = "black")
                legend("topleft", c("Inc. MYCYC data", "No MYCYC data"), col = c("green","black"), lty = c(1,1), lwd = c(3,3), cex=1.2, bty="n")
            }else{
            	## plot prior density based on expert opinion alone
            	priorPlot = plot(x$gride, x$dens, type="l", lty=1, lwd=3, col="black", main = "Prior density of 6-month remission rate on MMF (no MYCYC data)", xlab = "MMF 6-month remission rate", ylab="Density", xlim =c(0,1), cex.lab = 1.5, cex.axis=1.5, cex.main = 1.8)
            }
		}
	})
	
	output$pepc_density <- renderPlot({		
		## Plot the prior and posterior distributions for pE
		if(input$posterior40 | input$posterior20){
			y = pC_postDens()
			x = pE_postDens()
			
			if(!input$nomycyc){
				leg1 = c("CYC/steroids (inc. MYCYC data)", "MMF/steroids (inc. MYCYC data)")
			}else{
				leg1 = c("CYC/steroids (no MYCYC data)", "MMF/steroids (no MYCYC data)")
			}
			
			postPlot = plot(y$gridc, y$postd, type="l", lty=2, lwd=3, col="dark red", main="Posterior densities of 6-month remission rates on MMF and CYC", xlab = "6-month remission rate", ylab="Density", xlim =c(0,1), ylim = range(c(y$postd, x$postd)), cex.lab = 1.5, cex.axis=1.5, cex.main = 2) 
			lines(x$gride, x$postd, lty=2, lwd=3, col="dark green")
			legend("topleft", leg1, col = c("dark red","dark green"), lty = c(2,2), lwd = c(3,3), cex=1.2, bty="n")	
			
		}else{
			y = pC_priorDens()
			x = pE_priorDens()
			
			if(!input$nomycyc){
				leg1 = c("CYC/steroids (inc. MYCYC data)", "MMF/steroids (inc. MYCYC data)")
			}else{
				leg1 = c("CYC/steroids (no MYCYC)", "MMF/steroids (no MYCYC)")
			}
					
			priorPlot = plot(y$gridc, y$dens, type="l", lty=1, lwd=3, col="red", main = "Prior densities of 6-month remission rates on MMF and CYC", xlab = "6-month remission rate", ylab="Density", xlim =c(0,1), ylim = range(c(y$dens, x$dens)), cex.lab = 1.5, cex.axis=1.5, cex.main = 2)	
			lines(x$gride, x$dens, lty=1, lwd=3, col="green")
			legend("topleft", leg1, col = c("red","green"), lty = c(1,1), lwd = c(3,3), cex=1.2, bty="n")
				
		}
	})
	
	output$theta_density <- renderPlot({	
		## Plot the prior and posterior distributions for theta
		
		z = priorParam()
		if(!input$nomycyc){
			pe_lim1 = 1.0/(1 + exp(-(-2 + log(z[2]/(1-z[2])))))
			pe_lim2 = 1.0/(1 + exp(-(-1 + log(z[2]/(1-z[2])))))
			pe_lim3 = 1.0/(1 + exp(-(0 + log(z[2]/(1-z[2])))))
			pe_lim4 = 1.0/(1 + exp(-(1 + log(z[2]/(1-z[2])))))
			pe_lim5 = 1.0/(1 + exp(-(2 + log(z[2]/(1-z[2])))))
			label1 <- paste("6-month remission rate on MMF assuming that on CYC is ", round(z[2], 2), sep="")
		}else{
			pcmode = (z[1] -1)/(z[1] + z[2] -2)
			pe_lim1 = 1.0/(1 + exp(-(-2 + log(pcmode/(1-pcmode)))))
			pe_lim2 = 1.0/(1 + exp(-(-1 + log(pcmode/(1-pcmode)))))
			pe_lim3 = 1.0/(1 + exp(-(0 + log(pcmode/(1-pcmode)))))
			pe_lim4 = 1.0/(1 + exp(-(1 + log(pcmode/(1-pcmode)))))
			pe_lim5 = 1.0/(1 + exp(-(2 + log(pcmode/(1-pcmode)))))
			label1 <- paste("6-month remission rate on MMF assuming that on CYC is ", round(pcmode, 2), sep="")
		}
		
		
		if(input$posterior40 | input$posterior20){
			y = theta_priorDens()
			x = theta_postDens()
			
			if(!input$nomycyc){
				if(input$posterior40){
					leg1 = c(bquote("Posterior:" ~ n[C] ==  .(input$n_cyc40) ~ S[C]  == .(input$cyc_succ40) ~ n[M] == .(40 - input$n_cyc40) ~ S[M] ==  .(input$mmf_succ40)), "Prior (inc. MYCYC data)")
				}else{
					leg1 = c(bquote("Posterior:" ~ n[C] ==  .(input$n_cyc20) ~ S[C]  == .(input$cyc_succ20) ~ n[M] == .(20 - input$n_cyc20) ~ S[M] ==  .(input$mmf_succ20)), "Prior (inc. MYCYC data)")
				}
			}else{
				if(input$posterior40){
					leg1 = c(bquote("Posterior:" ~ n[C] ==  .(input$n_cyc40) ~ S[C]  == .(input$cyc_succ40) ~ n[M] == .(40 - input$n_cyc40) ~ S[M] ==  .(input$mmf_succ40)), "Prior (no MYCYC data)")
				}else{
					leg1 = c(bquote("Posterior:" ~ n[C] ==  .(input$n_cyc20) ~ S[C]  == .(input$cyc_succ20) ~ n[M] == .(20 - input$n_cyc20) ~ S[M] ==  .(input$mmf_succ20)), "Prior (no MYCYC data)")
				}
			}
			
			par(pty="m", plt=c(0.1, 1, 0, 1), omd=c(0.1,1.0,0,0.9))
			par(mfrow = c(2, 1))
			
			postPlot = plot(x$gridt, x$postd, type="l", lty=2, lwd=3, col="dark blue", main="", ylab="Density", xaxt = "n", cex.lab = 1.5, cex.axis=1.5, ylim = range(c(x$postd, y$dens))) 
			lines(y$gridt, y$dens, lty=1, lwd=3, col="blue")
			legend("topleft", as.expression(leg1), col = c("dark blue","blue"), lty = c(2,1), lwd = c(3,3), cex=1.2, bty="n")	
			mtext(side=3, "Prior and posterior densities of the log-odds ratio", line=1.5, cex = 2)
			
			## Setting up axis 1
			axis(side=1, at=c(-2, -1, 0, 1, 2), labels=c(-2, -1, 0, 1, 2), cex.axis=1.5)
			linloc <- par()$usr[3]
			abline(h=linloc, col="black")
			mtext(side=1, "log-odds ratio", line=2.5, cex=1.5, col="black")
			
			## axis 2
			xaxis2 = seq(-2, 2, by=1)
			par(plt=c(0.1,1,0.6,1))
			plot(xaxis2, type="n",xaxt="n", xlab="", yaxt="n", ylab="", xlim = c(-2, 2), bty="n")
			axis(side=1, at = c(-2, -1, 0, 1, 2), labels = round(c(pe_lim1, pe_lim2, pe_lim3, pe_lim4, pe_lim5), 2), col="red", col.axis="red", cex.axis=1.5)
			linloc <- par()$usr[3]
			abline(h=linloc, col="red")
			mtext(side=1, label1, line=3.0, cex=1.5, col="red")	
		}else{
			x = theta_priorDens()
			## Only want to plot the prior density in this scenario
			par(pty="m", plt=c(0.1, 1, 0, 1), omd=c(0.1,1.0,0,0.9))
			par(mfrow = c(2, 1))
			
            if(!input$nomycyc){
                z1 = scan("Day1Prior.txt", nmax=6)
            	z = vector(mode="numeric", length=10)
            	z[1] = z1[1]
            	z[2] = z1[2]
            	z[9] = z1[3]
            	z[10] = z1[4]
            	h = vector(mode="numeric", length = 20)
            	y = Plot_nomycyc(40 - input$n_cyc40, input$mmf_succ40, input$n_cyc40, input$cyc_succ40, h, z, as.character("theta"), as.logical("T"))
            	
                priorPlot = plot(x$gridt, x$dens, type="l", lty=1, lwd=3, col="blue", main="", ylab="Density", ylim = range(c(x$dens, y$dens)), xaxt="n", cex.lab = 1.5, cex.axis=1.5)
                lines(y$gridt, y$dens, lty=1, lwd =3, col = "black")
                legend("topleft", c("Inc. MYCYC data", "No MYCYC data"), col = c("blue","black"), lty = c(1,1), lwd = c(3,3), cex=1.2, bty="n")
                mtext(side=3, "Prior density of the log-odds ratio", line=1.5, cex = 2)
            }else{
            	priorPlot = plot(x$gridt, x$dens, type="l", lty=1, lwd=3, col="blue", main="", ylab="Density", xaxt="n", cex.lab = 1.5, cex.axis=1.5)
            	mtext(side=3, "Prior density of log-odds ratio (no MYCYC data)", line=1.5, cex = 2)
            }
			
			## Setting up axis 1
			axis(side=1, at=c(-2, -1, 0, 1, 2), labels=c(-2, -1, 0, 1, 2), cex.axis=1.5)
			linloc <- par()$usr[3]
			abline(h=linloc, col="black")
			mtext(side=1, "log-odds ratio", line=2.5, cex=1.5, col="black")
			
			## axis 2
			xaxis2 = seq(-2, 2, by=1)
			par(plt=c(0.1,1,0.6,1))
			plot(xaxis2, type="n",xaxt="n", xlab="", yaxt="n", ylab="", xlim = c(-2, 2), bty="n")
			axis(side=1, at = c(-2, -1, 0, 1, 2), labels = round(c(pe_lim1, pe_lim2, pe_lim3, pe_lim4, pe_lim5), 2), col="red", col.axis="red", cex.axis=1.5)
			linloc <- par()$usr[3]
			abline(h=linloc, col="red")
			mtext(side=1, label1, line=3.0, cex=1.5, col="red")	
		}
	})
	
	output$lambdaC_density <- renderPlot({	
        if(!input$nomycyc){
            ## Plot the prior distribution of lambdaC
            x = lambdaC_priorDens()
            mycyc_cyc = 47/70
            lbda_lim1 = mycyc_cyc/(exp(-3)*(1-mycyc_cyc) + mycyc_cyc)
            lbda_lim2 = mycyc_cyc/(exp(-2)*(1-mycyc_cyc) + mycyc_cyc)
            lbda_lim3 = mycyc_cyc/(exp(-1)*(1-mycyc_cyc) + mycyc_cyc)
            lbda_lim4 = mycyc_cyc/((1-mycyc_cyc) + mycyc_cyc)
            lbda_lim5 = mycyc_cyc/(exp(1)*(1-mycyc_cyc) + mycyc_cyc)
            lbda_lim6 = mycyc_cyc/(exp(2)*(1-mycyc_cyc) + mycyc_cyc)
            lbda_lim7 = mycyc_cyc/(exp(3)*(1-mycyc_cyc) + mycyc_cyc)
		
            label1 <- paste("MYPAN CYC remission rate assuming MYCYC CYC remission rate is ", round(mycyc_cyc, 2), sep="")
		
            par(pty="m", plt=c(0.1, 1, 0, 1), omd=c(0.1,1.0,0,0.9))
            par(mfrow = c(2, 1))
            priorPlot = plot(x$gridl, x$dens, type="l", lty=1, lwd=3, col="orange", main = "", ylab="Density", xaxt = "n", cex.lab = 1.5, cex.axis=1.5)	   
            ## Setting up axis 1
            axis(side=1, at=c(-3, -2, -1, 0, 1, 2, 3), labels=c(-3, -2, -1, 0, 1, 2, 3), cex.axis=1.5)
            linloc <- par()$usr[3]
            abline(h=linloc, col="black")
            mtext(side=1, "log-odds ratio", line=2.5, cex=1.5, col="black")
			
            ## axis 2
            xaxis2 = seq(-3, 3, by=1)
            par(plt=c(0.1,1,0.6,1))
            plot(xaxis2, type="n",xaxt="n", xlab="", yaxt="n", ylab="", xlim = c(-3, 3), bty="n")
            axis(side=1, at = c(-3, -2, -1, 0, 1, 2, 3), labels = round(c(lbda_lim1, lbda_lim2, lbda_lim3, lbda_lim4, lbda_lim5, lbda_lim6, lbda_lim7), 2), col="red", col.axis="red", cex.axis=1.5)
            linloc <- par()$usr[3]
            abline(h=linloc, col="red")
            mtext(side=1, label1, line=3.0, cex=1.5, col="red")
        }else{
            NULL
        }
	})
	
	output$lambdaE_density <- renderPlot({	
    
        if(!input$nomycyc){
            ## Plot the prior distribution of lambdaE
            x = lambdaE_priorDens()
            mycyc_mmf = 36/70
            lbda_lim1 = mycyc_mmf/(exp(-3)*(1-mycyc_mmf) + mycyc_mmf)
            lbda_lim2 = mycyc_mmf/(exp(-2)*(1-mycyc_mmf) + mycyc_mmf)
            lbda_lim3 = mycyc_mmf/(exp(-1)*(1-mycyc_mmf) + mycyc_mmf)
            lbda_lim4 = mycyc_mmf/((1-mycyc_mmf) + mycyc_mmf)
            lbda_lim5 = mycyc_mmf/(exp(1)*(1-mycyc_mmf) + mycyc_mmf)
            lbda_lim6 = mycyc_mmf/(exp(2)*(1-mycyc_mmf) + mycyc_mmf)
            lbda_lim7 = mycyc_mmf/(exp(3)*(1-mycyc_mmf) + mycyc_mmf)
		
            label1 <- paste("MYPAN MMF remission rate assuming MYCYC MMF remission rate is ", round(mycyc_mmf, 2), sep="")
		
            par(pty="m", plt=c(0.1, 1, 0, 1), omd=c(0.1,1.0,0,0.9))
            par(mfrow = c(2, 1))
            priorPlot = plot(x$gridl, x$dens, type="l", lty=1, lwd=3, col="orange", main = "", ylab="Density", xaxt = "n", cex.lab = 1.5, cex.axis=1.5)	   
            ## Setting up axis 1
            axis(side=1, at=c(-3, -2, -1, 0, 1, 2, 3), labels=c(-3, -2, -1, 0, 1, 2, 3), cex.axis=1.5)
            linloc <- par()$usr[3]
            abline(h=linloc, col="black")
            mtext(side=1, "log-odds ratio", line=2.5, cex=1.5, col="black")
			
            ## axis 2
            xaxis2 = seq(-3, 3, by=1)
            par(plt=c(0.1,1,0.6,1))
            plot(xaxis2, type="n",xaxt="n", xlab="", yaxt="n", ylab="", xlim = c(-3, 3), bty="n")
            axis(side=1, at = c(-3, -2, -1, 0, 1, 2, 3), labels = round(c(lbda_lim1, lbda_lim2, lbda_lim3, lbda_lim4, lbda_lim5, lbda_lim6, lbda_lim7), 2), col="red", col.axis="red", cex.axis=1.5)
            linloc <- par()$usr[3]
            abline(h=linloc, col="red")
            mtext(side=1, label1, line=3.0, cex=1.5, col="red")
        }else{
            NULL
        }
	})
		
	## Generate a summary of the prior or posterior densities as necessary
	output$mypan = renderPrint({
		if((input$posterior40 | input$posterior20) & !input$nomycyc){
			
			x = postParam()
			z = scan("D1Answers.txt", nmax = 4)
			
			cat("Summary of the posterior distributions when priors incorporate data from the MYCYC trial: \n")
			cat("\n")
			cat("\n")
			cat("Posterior distributions update the priors implied by the Day 1 opinions: Q1 = ", z[1], ", Q2 = ", z[2], ", Q3 = ", z[3], ", Q4 = ", z[4], "\n")
			cat("\n")
			cat("and the opinions expressed on Day 2: D2Q1 = ", input$lambdaC_q1, ", D2Q2 = ", input$lambdaC_q2, ", D2Q3 = ",input$lambdaE_q1, ", D2Q4 = ", input$lambdaE_q2, "\n")
			cat("\n")
			cat("\n")
			cat("Posterior distributions incorporate the following hypothetical data from the MYPAN trial: \n")
			if(input$posterior40){
				cat(input$n_cyc40, "patients randomised to CYC of whom ", input$cyc_succ40, "were in remission within six months \n")
				cat(40 - input$n_cyc40, "patients randomised to MMF of whom ", input$mmf_succ40, "were in remission within six months \n")
			}else{
				cat(input$n_cyc20, "patients randomised to CYC of whom ", input$cyc_succ20, "were in remission within six months \n")
				cat(20 - input$n_cyc20, "patients randomised to MMF of whom ", input$mmf_succ20, "were in remission within six months \n")
			}
			
			cat("\n")
			cat("\n")
			cat("Summary of the posterior distribution of the 6-month remission rate on CYC/steroids: \n")
			cat("\n")			
			cat("Your distribution has mode ", round(x[2], 2), " and mean ", round(x[1], 2), "and standard deviation ", round(x[3], 2))	
			cat("\n")
			cat("\n")
			cat("Summary of the posterior distribution of the 6-month remission rate on MMF/steroids: \n")
			cat("\n")
			cat("Your distribution has mode ", round(x[8], 2), " and mean ", round(x[7], 2), "and standard deviation", round(x[9], 2), "\n")
			cat("\n")
			cat("\n")
			cat("Summary of the posterior distribution of the log-odds ratio: \n")
			cat("\n")
			cat("Your distribution has mode ", round(x[13], 2), " and mean ", round(x[12], 2), "and standard deviation ", round(x[14], 2), "\n")			
			
		}else if((input$posterior40 | input$posterior20) & input$nomycyc){
			
			x = postParam()
			z = scan("D1Answers.txt", nmax = 4)
			
			cat("Summary of the posterior distributions when priors don't incorporate data from the MYCYC trial: \n")
			cat("\n")
			cat("\n")
			cat("Posterior distributions update the priors implied by the Day 1 opinions: Q1 = ", z[1], ", Q2 = ", z[2], ", Q3 = ", z[3], ", Q4 = ", z[4], "\n")
			cat("\n")
			cat("Posterior distributions incorporate the following hypothetical data from the MYPAN trial: \n")
			
			if(input$posterior40){
				cat(input$n_cyc40, "patients randomised to CYC of whom ", input$cyc_succ40, "were in remission within six months \n")
				cat(40 - input$n_cyc40, "patients randomised to MMF of whom ", input$mmf_succ40, "were in remission within six months \n")
			}else{
				cat(input$n_cyc20, "patients randomised to CYC of whom ", input$cyc_succ20, "were in remission within six months \n")
				cat(20 - input$n_cyc20, "patients randomised to MMF of whom ", input$mmf_succ20, "were in remission within six months \n")
			}
			
			cat("\n")
			cat("\n")
			cat("Summary of the posterior distribution of the 6-month remission rate on CYC/steroids: \n")
			cat("\n")			
			cat("90% credibility interval for CYC remission rate is (", round(x[4], 2), ",", round(x[5], 2), ") \n") 
			cat("Your distribution has mode ", round(x[2], 2), " and mean ", round(x[1], 2), "and standard deviation ", round(x[3], 2))	
			cat("\n")
			cat("\n")
			cat("Summary of the posterior distribution of the 6-month remission rate on MMF/steroids: \n")
			cat("\n")
			cat("90% credibility interval for MMF remission rate is (", round(x[9], 2), ",", round(x[10], 2), ") \n")
			cat("Your distribution has mode ", round(x[7], 2), " and mean ", round(x[6], 2), "and standard deviation", round(x[8], 2), "\n")
			cat("\n")
			cat("\n")
			cat("Summary of the posterior distribution of the log-odds ratio: \n")
			cat("\n")
			cat("90% credibility interval for the log-odds ratio is (", round(x[14], 2), ",", round(x[15], 2), ") \n") 
			cat("Your distribution for the log-odds ratio has mode ", round(x[12], 2), " and mean ", round(x[11], 2), "and standard deviation ", round(x[13], 2), "\n")			
			cat("\n")
			cat("\n")
			cat("Posterior probability that the 6-month remission rate on MMF exceeds that on CYC is ", round(x[16], 2), "\n")
			cat("Posterior probability that the 6-month remission rate on MMF is at worst 10% less than that on CYC is", round(x[17], 2), "\n")
			cat("Posterior probability that the 6-month remission rate on CYC exceeds that on MMF by more than 10% is ", round(1 - x[17], 2), "\n")	
				
		}else if(!input$posterior40 & !input$posterior20 & !input$nomycyc){
			
			x = priorParam()
			z = scan("D1Answers.txt", nmax = 4)
			cat("Summary of the prior distributions incorporating data from the MYCYC trial: \n")
			cat("\n")
			cat("\n")
			cat("Prior distributions are determined by the opinions expressed on Day 1: D1Q1 = ", z[1], ", D1Q2 = ", z[2], ", D1Q3 = ", z[3], ", D1Q4 = ", z[4], "\n")
			cat("and the opinions expressed on Day 2: D2Q1 = ", input$lambdaC_q1, ", D2Q2 = ", input$lambdaC_q2, ", D2Q3 = ",input$lambdaE_q1, ", D2Q4 = ", input$lambdaE_q2, "\n")
			cat("\n")
			cat("\n")
			
			cat("Summary of the prior distribution of the 6-month remission rate on CYC/steroids: \n")
			cat("\n")
			cat("Your distribution has mode ", round(x[2], 2), " and mean ",round(x[1], 2), "and standard deviation ", round(x[3], 2), "\n")		
			cat("This information is equivalent to ", round(x[6], 0), "observations on CYC. \n")
			cat("\n")
			cat("\n")
			cat("Summary of the prior distribution of the 6-month remission rate on MMF/steroids: \n")
			cat("\n")
			cat("Your distribution has mode ", round(x[8], 2), " and mean ", round(x[7], 2), " and standard deviation ", round(x[9], 2), "\n")
			cat("\n")
			cat("\n")
			cat("Summary of the prior distribution of log-odds ratio : \n")
			cat("\n")
			cat("Your distribution has mode ", round(x[13], 2), " and mean", round(x[12], 2), " and standard deviation ", round(x[14], 2), "\n")
			cat("This information is equivalent to what would be generated by a RCT comparing CYC with MMF recruiting ", round(0.5*x[17], 0), "patients per treatment arm \n")

		}else{
			x = priorParam()
			z = scan("D1Answers.txt", nmax = 4)
			cat("Summary of the prior distributions not incorporating data from the MYCYC trial: \n")
			cat("\n")
			cat("Prior distributions are determined by the opinions expressed on Day 1: Q1 = ", z[1], ", Q2 = ", z[2], ", Q3 = ", z[3], ", Q4 = ", z[4], "\n")
			cat("\n")
			cat("\n")
			
			pcquantile0_05 = qbeta(0.05, shape1 = x[1], shape2 = x[2], lower.tail=TRUE)
			pcquantile0_95 = qbeta(0.95, shape1 = x[1], shape2 = x[2], lower.tail=TRUE)
			pc_mode = (x[1] - 1)/(x[1] + x[2] -2)
			pc_mean = x[1]/(x[1] + x[2])
			pc_var = (x[1]*x[2])/(((x[1] + x[2])^2)*(x[1] + x[2] +1))
			
			tquantile0_05 = qnorm(0.05, mean=x[9], sd = sqrt(x[10]), lower.tail=TRUE)
			tquantile0_95 = qnorm(0.95, mean=x[9], sd = sqrt(x[10]), lower.tail=TRUE)
			
			cat("Summary of the prior distribution of CYC/steroids 6-month remission rate: \n")
			cat("\n")
			cat("90% credibility interval for CYC remission rate is (", round(pcquantile0_05, 2), " , ", round(pcquantile0_95, 2), ") \n")
			cat("Your distribution is Beta with parameters ", round(x[1], 2), " and ", round(x[2], 2), "\n")
			cat("with mode ", round(pc_mode, 2), " and mean ",round(pc_mean, 2), "and standard deviation ", round(sqrt(pc_var), 2), "\n")		
			cat("This information is equivalent to ", round(x[3], 0), "observations on CYC. \n")
			cat("\n")
			cat("\n")
			cat("Summary of the prior distribution of MMF/steroids 6-month remission rate: \n")
			cat("\n")
			cat("90% credibility interval for MMF remission rate is (", round(x[7], 2), ",", round(x[8], 2), ") \n")
			cat("Your distribution has mode ", round(x[5], 2), " and mean ", round(x[4], 2), " and standard deviation ", round(x[6], 2), "\n")
			cat("Proportion which we are 75% confident the MMF success rate in MYPAN will lie exceed ", round(x[14], 2), "\n")
			cat("\n")
			cat("\n")
			cat("Summary of the prior distribution of log-odds ratio : \n")
			cat("\n")
			cat("90% credibility interval for log-odds ratio is (", round(tquantile0_05, 2), ",", round(tquantile0_95, 2), ") \n")
			cat("Your distribution is Gaussian with mode ", round(x[9], 2), " and mean", round(x[9], 2), " and standard deviation ", round(sqrt(x[10]), 2), "\n")
			cat("This information is equivalent to what would be generated by a RCT comparing CYC with MMF recruiting ", round(0.5*x[13], 0), "patients per treatment arm \n")
			cat("\n")
			cat("\n")
			cat("Prior probability that the 6-month remission rate on MMF exceeds that on CYC is ", round(x[11], 2),  "\n")
			cat("Prior probability that the 6-month remission rate on MMF is at worst 10% less than that on CYC is", round(1 - x[12], 2), "\n")
			cat("Prior probability that the 6-month remission rate on CYC exceeds that on MMF by more than 10% is ", round(x[12], 2), "\n")
		}		
	})
		
})
